const animatedElements = document.querySelectorAll(
    '.Heading-Second-Block, .Heading-First-Block, ' +
    '.Place-For-Element3, .Place-For-Element6, .Place-For-Element8, .Footer, ' +
    '.Line-Of-Fifth-Block, .Line-Third-Block, ' +
    '.Left-Place-Third-Block, .Right-Place-Third-Block'
);

function isElementInViewport(element) {
    const rect = element.getBoundingClientRect();
    const windowHeight = window.innerHeight || document.documentElement.clientHeight;
    
    const triggerPoint = windowHeight * 0.8;
    
    return (
        rect.top <= triggerPoint &&
        rect.bottom >= 0
    );
}

function handleScrollAnimation() {
    animatedElements.forEach(element => {
        if (isElementInViewport(element)) {
            element.classList.add('Visible');
        }
    });
}

document.addEventListener('DOMContentLoaded', () => {
    
    handleScrollAnimation();
    
    
    window.addEventListener('scroll', handleScrollAnimation);
    
    let scrollTimeout;
    window.addEventListener('scroll', () => {
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(handleScrollAnimation, 50);
    });
});


window.addEventListener('DOMContentLoaded', () => {
    const firstBlockHeading = document.querySelector('.Heading-First-Block');
    if (firstBlockHeading) {
        setTimeout(() => {
            firstBlockHeading.classList.add('Visible');
        }, 500); 
    }
});